﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
''' 单个订单
''' </summary>
Public Class Order

    Public Sub New()
    End Sub

    ''' <summary>
    ''' 创建一个新订单
    ''' </summary>
    ''' <param name="orderid">此订单的标识符</param>
    ''' <param name="customerID">下此订单的客户</param>
    ''' <param name="orderDate">下订单的日期</param>
    ''' <param name="shippedDate">订单的发货日期</param>
    Public Sub New(ByVal orderid As Integer, ByVal customerID As String, ByVal orderDate As DateTime, ByVal shippedDate As DateTime)
        orderIDValue = orderid
        customerIDValue = customerID
        orderDateValue = orderDate
        shippedDateValue = shippedDate
    End Sub

    Private orderIDValue As String
    ''' <summary>
    ''' 订单的标识符
    ''' </summary>
    Public ReadOnly Property OrderID() As String
        Get
            Return orderIDValue
        End Get
    End Property

    Private customerIDValue As String
    ''' <summary>
    ''' 下此订单的客户
    ''' </summary>
    Public Property CustomerID() As String
        Get
            Return customerIDValue
        End Get
        Set(ByVal Value As String)
            customerIDValue = Value
        End Set
    End Property

    Private orderDateValue As DateTime
    ''' <summary>
    ''' 下订单的日期
    ''' </summary>
    Public Property OrderDate() As DateTime
        Get
            Return orderDateValue
        End Get
        Set(ByVal Value As DateTime)
            orderDateValue = Value
        End Set
    End Property

    Private shippedDateValue As DateTime
    ''' <summary>
    ''' 订单的发货日期
    ''' </summary>
    Public Property ShippedDate() As DateTime
        Get
            Return shippedDateValue
        End Get
        Set(ByVal Value As DateTime)
            shippedDateValue = Value
        End Set
    End Property
End Class

''' <summary>
''' Orders 集合
''' </summary>
Public Class Orders
    Inherits System.ComponentModel.BindingList(Of Order)
End Class